/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.resourcestab;

import filenet.sim.api.VWScenarioQueueAssignment;
import filenet.sim.api.VWScenarioRoleDefinition;
import filenet.sim.toolkit.designer.properties.IVWSIMPropertyChangeListener;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyChangeEvent;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMQueuesAddRemovePanel;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMRolesTableModel;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWListUpdateListener;
import filenet.vw.toolkit.utils.VWSplitPane;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.ComponentOrientation;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class VWSIMRolesPropertiesTab
extends JPanel
implements DocumentListener,
ActionListener,
IVWSIMPropertyChangeListener,
ListSelectionListener,
TableModelListener,
IVWToolbarBorderActionListener,
IVWListUpdateListener {
    private VWToolbarBorder m_rolesBorder = null;
    private VWTable m_rolesTable = null;
    private VWSIMRolesTableModel m_rolesTableModel = null;
    private VWToolbarBorder m_queuesBorder = null;
    private VWSIMQueuesAddRemovePanel m_queuesAddRemovePanel = null;
    private VWSIMPropertyData m_propertyData = null;
    private String m_selectedQueueName = null;

    public void init(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.m_propertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridLayout());
        this.initTableControls();
        this.initQueuesControls();
        Locale browserLocale = this.m_propertyData.getSessionInfo().getBrowserLocale();
        ComponentOrientation compOrientation = null;
        compOrientation = browserLocale != null ? ComponentOrientation.getOrientation(browserLocale) : ComponentOrientation.LEFT_TO_RIGHT;
        if (compOrientation.isLeftToRight()) {
            VWSplitPane splitPane = new VWSplitPane(1, this.m_rolesBorder, this.m_queuesBorder);
            splitPane.setToolTipText(VWSIMResource.s_splitterToolTip);
            splitPane.setDividerLocation(0.2);
            splitPane.setDividerSize(6);
            splitPane.setResizeWeight(0.5);
            this.add(splitPane);
        } else {
            VWSplitPane splitPane = new VWSplitPane(1, this.m_queuesBorder, this.m_rolesBorder);
            splitPane.setToolTipText(VWSIMResource.s_splitterToolTip);
            splitPane.setDividerLocation(0.7);
            splitPane.setDividerSize(6);
            splitPane.setResizeWeight(0.5);
            this.add(splitPane);
        }
        this.reinitialize();
    }

    public void releaseReferences() {
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void actionPerformed(ActionEvent event) {
    }

    public void propertyDataChanged(VWSIMPropertyChangeEvent event) {
        switch (event.getID()) {
            case 101: {
                this.reinitialize();
                break;
            }
            case 103: {
                if (this.m_rolesTable == null) break;
                this.m_rolesTable.stopEditing();
                break;
            }
            case 115: {
                if (this.m_rolesTable == null || event.getSource() == this.m_rolesTableModel) break;
                int nSelectedRow = this.m_rolesTable.getSelectedRow();
                this.m_rolesTableModel.addItem(event.getParam());
                if (nSelectedRow == -1 || this.m_rolesTableModel.getRowCount() <= nSelectedRow) break;
                this.m_rolesTable.setRowSelectionInterval(nSelectedRow, nSelectedRow);
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (!event.getValueIsAdjusting()) {
                int nSelectedRow = this.m_rolesTable.getSelectedRow();
                this.m_rolesBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_rolesBorder.getClientPanel(), 2, Integer.MAX_VALUE));
                this.m_rolesBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_rolesBorder.getClientPanel(), 1, 16));
                if (this.m_rolesTableModel != null && nSelectedRow != -1) {
                    this.m_rolesBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_rolesBorder.getClientPanel(), 1, Integer.MAX_VALUE));
                }
                if (this.m_queuesAddRemovePanel != null) {
                    this.m_queuesAddRemovePanel.reinitialize(this.m_rolesTableModel.getItemAt(nSelectedRow));
                    this.m_queuesAddRemovePanel.setEnabled(true);
                    this.setQueuePriorityPanelEnabled(false);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int row = event.getLastRow() - 1;
                if (row < 0) {
                    row = 0;
                }
                if (row == this.m_rolesTable.getSelectedRow()) {
                    this.m_rolesTable.clearSelection();
                }
                if (row >= 0 && this.m_rolesTableModel.getRowCount() > 0) {
                    this.m_rolesTable.setRowSelectionInterval(row, row);
                }
                this.updateTableToolbar();
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 16: {
                    this.m_rolesTableModel.addItem();
                    break;
                }
                case 64: {
                    int nSelectedRow = this.m_rolesTable.getSelectedRow();
                    this.m_rolesTableModel.copyItem(nSelectedRow);
                    break;
                }
                case 0x10000000: {
                    int nSelectedRow = this.m_rolesTable.getSelectedRow();
                    this.m_rolesTableModel.deleteItem(nSelectedRow);
                    if (this.m_rolesTableModel.getRowCount() != 0) break;
                    this.m_queuesAddRemovePanel.removeListUpdateListener(this);
                    this.m_queuesAddRemovePanel.reinitialize(null);
                    this.m_queuesAddRemovePanel.addListUpdateListener(this);
                    this.m_queuesAddRemovePanel.setEnabled(false);
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void listUpdated(Object source, int nEventType, Object[] items) {
    }

    private void initTableControls() {
        this.m_rolesBorder = new VWToolbarBorder(VWSIMResource.s_jobs, 0x10000050);
        this.m_rolesBorder.addToolbarBorderActionNotifier(this);
        JPanel resourcesPanel = this.m_rolesBorder.getClientPanel();
        resourcesPanel.setLayout(new GridLayout());
        this.m_rolesTableModel = new VWSIMRolesTableModel(this.m_propertyData);
        this.m_rolesTableModel.addTableModelListener(this);
        this.m_rolesTable = new VWTable(this.m_rolesTableModel);
        this.m_rolesTable.setRowSelectionAllowed(true);
        this.m_rolesTable.getSelectionModel().addListSelectionListener(this);
        this.m_rolesTable.getSelectionModel().setSelectionMode(0);
        this.m_rolesTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
        this.m_rolesTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
        resourcesPanel.add(new JScrollPane(this.m_rolesTable));
        this.updateTableToolbar();
    }

    private void updateTableToolbar() {
        this.m_rolesBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_rolesBorder.getClientPanel(), 2, Integer.MAX_VALUE));
        this.m_rolesBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_rolesBorder.getClientPanel(), 1, 16));
        if (this.m_rolesTableModel.getRowCount() > 0) {
            this.m_rolesBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_rolesBorder.getClientPanel(), 1, Integer.MAX_VALUE));
        }
    }

    private void initQueuesControls() {
        this.m_queuesBorder = new VWToolbarBorder(VWSIMResource.s_queueProcessingOrder, 0);
        JPanel queuesPanel = this.m_queuesBorder.getClientPanel();
        queuesPanel.setLayout(new GridLayout());
        this.m_queuesAddRemovePanel = new VWSIMQueuesAddRemovePanel(this.m_propertyData);
        this.m_queuesAddRemovePanel.addListUpdateListener(this);
        queuesPanel.add(this.m_queuesAddRemovePanel);
    }

    private void initQueuePriorityControls() {
    }

    private void reinitialize() {
        try {
            this.m_queuesAddRemovePanel.removeListUpdateListener(this);
            this.m_queuesAddRemovePanel.reinitialize(null);
            this.m_queuesAddRemovePanel.addListUpdateListener(this);
            this.m_rolesTableModel.reinitialize();
            this.updateTableToolbar();
            this.m_queuesAddRemovePanel.setEnabled(false);
            this.m_rolesTable.clearSelection();
            if (this.m_rolesTableModel.getRowCount() > 0) {
                this.m_rolesTable.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void setQueuePriorityPanelEnabled(boolean enable) {
    }

    private void performNoneRadioButton() {
        try {
            VWScenarioQueueAssignment queueAssignment;
            int row = this.m_rolesTable.getSelectedRow();
            VWScenarioRoleDefinition roleDef = this.m_rolesTableModel.getItemAt(row);
            if (roleDef != null && this.m_selectedQueueName != null && (queueAssignment = roleDef.getQueueAssignment(this.m_selectedQueueName)) != null) {
                queueAssignment.setPriorityType(0);
                this.m_propertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performOldestProcessInstanceRadioButton() {
        try {
            VWScenarioQueueAssignment queueAssignment;
            int row = this.m_rolesTable.getSelectedRow();
            VWScenarioRoleDefinition roleDef = this.m_rolesTableModel.getItemAt(row);
            if (roleDef != null && this.m_selectedQueueName != null && (queueAssignment = roleDef.getQueueAssignment(this.m_selectedQueueName)) != null) {
                queueAssignment.setPriorityType(2);
                this.m_propertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performLongestWaitingQueueRadioButton() {
        try {
            VWScenarioQueueAssignment queueAssignment;
            int row = this.m_rolesTable.getSelectedRow();
            VWScenarioRoleDefinition roleDef = this.m_rolesTableModel.getItemAt(row);
            if (roleDef != null && this.m_selectedQueueName != null && (queueAssignment = roleDef.getQueueAssignment(this.m_selectedQueueName)) != null) {
                queueAssignment.setPriorityType(3);
                this.m_propertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performFieldPriorityRadioButton() {
        try {
            VWScenarioQueueAssignment queueAssignment;
            int row = this.m_rolesTable.getSelectedRow();
            VWScenarioRoleDefinition roleDef = this.m_rolesTableModel.getItemAt(row);
            if (roleDef != null && this.m_selectedQueueName != null && (queueAssignment = roleDef.getQueueAssignment(this.m_selectedQueueName)) != null) {
                queueAssignment.setPriorityType(1);
                this.m_propertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updatePriorityAddRemovePanel(Object[] items) {
    }

    private void updateQueuesAddRemovePanel(Object[] items) {
    }
}

